﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.Xml.Linq;

namespace Xml
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        static string katalogAplikacji
        {
            get
            {
                string katalog = System.IO.Path.GetDirectoryName(System.Reflection.Assembly.GetExecutingAssembly().GetName().CodeBase);
                if (katalog.StartsWith("file:")) katalog = katalog.Remove(0, 6);
                return katalog;
            }
        }

        string sciezkaPlikuXml = System.IO.Path.Combine(katalogAplikacji, "StanKontrolek.xml");

        //*
        private void Form1_Closed(object sender, EventArgs e)
        {
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XComment("Ustawienia kontrolek"),
                new XElement("stan",
                    new XElement("kontrolki",
                        new XAttribute("nazwa", this.Text),
                        new XElement(textBox1.Name,
                        new XElement("Text", textBox1.Text)            
                    ),
                    new XElement(checkBox1.Name,
                        new XElement("Checked", checkBox1.Checked),
                        new XElement("Text", checkBox1.Text)
                    ),
                    new XElement(trackBar1.Name,
                        new XElement("Value",trackBar1.Value))
                    )
                )
            );

            xml.Save(sciezkaPlikuXml);
        }
        
        //*/
        /*
        private void Form1_Closed(object sender, EventArgs e)
        {
            //definiowanie obiektów
            XDocument xml = new XDocument();
            XDeclaration deklaracja = new XDeclaration("1.0", "utf-8", "yes");
            XComment komentarz = new XComment("Ustawienia kontrolek");
            XElement elementStan = new XElement("stan");
            XElement elementKontrolki = new XElement("kontrolki");
            XAttribute atrybutNazwa = new XAttribute("nazwa", this.Text);
            XElement elementTB1 = new XElement(textBox1.Name);
            XElement elementTB1Text = new XElement("Text", textBox1.Text);
            XElement elementCB1 = new XElement(checkBox1.Name);
            XElement elementCB1Checked = new XElement("Checked", checkBox1.Checked);
            XElement elementCB1Text = new XElement("Text", checkBox1.Text);
            XElement elementTrB1 = new XElement(trackBar1.Name);
            XElement elementTrB1Value = new XElement("Value", trackBar1.Value);

            //budowanie drzewa
            elementTB1.Add(elementTB1Text);
            elementCB1.Add(elementCB1Checked);
            elementCB1.Add(elementCB1Text);            
            elementTrB1.Add(elementTrB1Value);
            elementKontrolki.Add(elementTB1);
            elementKontrolki.Add(elementCB1);
            elementKontrolki.Add(elementTrB1);
            elementStan.Add(elementKontrolki);

            xml.Declaration = deklaracja;
            xml.Add(komentarz);
            xml.Add(elementStan);

            //zapis do pliku
            xml.Save(sciezkaPlikuXml);
        }
        */

        private void Form1_Load(object sender, EventArgs e)
        {
            try
            {
                XDocument xml = XDocument.Load(sciezkaPlikuXml);
                XElement elementKontrolki = xml.Root.Element("kontrolki");

                this.Text = elementKontrolki.Attribute("nazwa").Value;

                textBox1.Text = elementKontrolki.Element(textBox1.Name).Element("Text").Value;
                XElement elementCB1 = elementKontrolki.Element(checkBox1.Name);
                checkBox1.Checked = bool.Parse(elementCB1.Element("Checked").Value);
                checkBox1.Text = elementCB1.Element("Text").Value;
                trackBar1.Value = int.Parse(elementKontrolki.Element(trackBar1.Name).Element("Value").Value);
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd podczas odczytywania pliku XML:\n" + exc.Message);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            XDocument xml = XDocument.Load(sciezkaPlikuXml);

            //wersja XML
            string wersja = xml.Declaration.Version;
            MessageBox.Show("Wersja XML: " + wersja);

            //odczytanie nazwy głównego elementu
            string nazwaElementuGlownego = xml.Root.Name.LocalName;
            MessageBox.Show("Nazwa elementu głównego: " + nazwaElementuGlownego);

            //kolekcja podelementów ze wszystkich poziomów drzewa
            IEnumerable<XElement> wszystkiePodelementy = xml.Root.Descendants();
            string s = "Wszystkie podelementy:\n";
            foreach (XElement podelement in wszystkiePodelementy) s += podelement.Name + "\n";
            MessageBox.Show(s);

            //kolekcja podelementóow elementu kontrolki
            IEnumerable<XElement> podelementyKontrolki = xml.Root.Element("kontrolki").Elements();
            s = "Podelementy elementu kontrolki:\n";
            foreach (XElement podelement in podelementyKontrolki) s += podelement.Name + "\n";
            MessageBox.Show(s);

        }
    }
}